img = {}
	img.splashsb2011= image.load("img/splashsb2011.png")
	img.bg= image.load("img/bg.png")
	img.puntero = image.load("img/puntero.png")
	img.paleta = {}
		img.paleta.circulo = image.load("img/paleta-circulo.png")
		img.paleta.degradado = image.load("img/paleta-degradado.png")

circulo = {x = 50,y =240-img.paleta.circulo:height()/2,w=img.paleta.circulo:width(),h=img.paleta.circulo:height()}
degradado = {x = 475,y =240-img.paleta.degradado:height()/2,w=img.paleta.degradado:width(),h=img.paleta.degradado:height()}		
clr = {}
	clr[1] = color.new(255,255,255)
	clr[2] = color.new(255,0,0)
	clr[3] = color.new(0,255,0)
	clr[4] = color.new(0,0,255)
	
pnt = {x = 1,y = 1}
	
function splashsb2011()
	for i = 0, 190,0.5 do
		img.splashsb2011:blend(0,0,i)
		screen.flip()
	end
	for i = 190, 0,-1 do
		img.splashsb2011:blend(0,0,i)
		screen.flip()
	end
end	

grid ={
{color.new(255,255,255)}
}



grid.hor = 20; grid.ver = 20; grid.w = 15; grid.h = 15;
function grid.update()
	grid.checklimits()
	grid.x = 320-(grid.w*grid.hor)/2
	grid.y = 240-(grid.h*grid.ver)/2
	if grid.ver < #grid  then
		while grid.ver < #grid do table.remove(grid) end
	elseif grid.ver > #grid  then
		while grid.ver > #grid do table.insert(grid,{}) end
	end
	for y = 1 , grid.ver do
		if grid.hor < #grid[y]  then
			while grid.hor < #grid[y] do table.remove(grid[y]) end
		elseif grid.hor > #grid[y]  then
			while grid.hor > #grid[y] do table.insert(grid[y],color.new(255,255,255)) end
		end
	end
end

function controls.ircollision(x,y,w,h)
	if controls.wiimote.irx() >= x and controls.wiimote.irx() <= x+w and 
	   controls.wiimote.iry() >= y and controls.wiimote.iry() <= y+h then
		return true
	end
	return false
end

function show_paleta()
	while true do
	img.bg:blit(0,0)
	controls.read()
	--grid.blit()
	img.paleta.circulo:blit(circulo.x,circulo.y)
	img.paleta.degradado:blit(degradado.x,degradado.y)
	puntero_blit()
	show_colors(30,440,25,25,30)
	blit_info()
	if controls.wiimote.home() then os.exit() end
	--Paleta circulo
		if controls.ircollision(circulo.x,circulo.y,circulo.w,circulo.h) then
			if controls.wiimote.a() then
				clr[1] = img.paleta.circulo:pixel(controls.wiimote.irx()-circulo.x,controls.wiimote.iry()-circulo.y) end
			if controls.wiimote.b() then
				clr[2] = img.paleta.circulo:pixel(controls.wiimote.irx()-circulo.x,controls.wiimote.iry()-circulo.y) end
			if controls.nunchuk.c() then
				clr[3] = img.paleta.circulo:pixel(controls.wiimote.irx()-circulo.x,controls.wiimote.iry()-circulo.y) end
			if controls.nunchuk.z() then
				clr[4] = img.paleta.circulo:pixel(controls.wiimote.irx()-circulo.x,controls.wiimote.iry()-circulo.y) end
		elseif controls.ircollision(degradado.x,degradado.y,degradado.w,degradado.h) then
			if controls.wiimote.a() then
				clr[1] = img.paleta.degradado:pixel(controls.wiimote.irx()-degradado.x,controls.wiimote.iry()-degradado.y) end
			if controls.wiimote.b() then
				clr[2] = img.paleta.degradado:pixel(controls.wiimote.irx()-degradado.x,controls.wiimote.iry()-degradado.y) end
			if controls.nunchuk.c() then
				clr[3] = img.paleta.degradado:pixel(controls.wiimote.irx()-degradado.x,controls.wiimote.iry()-degradado.y) end
			if controls.nunchuk.z() then
				clr[4] = img.paleta.degradado:pixel(controls.wiimote.irx()-degradado.x,controls.wiimote.iry()-degradado.y) end
		end
	screen.flip()
	if controls.wiimote.release("plus") then break end
	end
end

function pnt.testxy(x,y,w,h)
	if pnt.x >= x and pnt.x <= x+(w-1) and pnt.y >= y and pnt.y <= y+(h-1) then return true end
	return false
end

function grid.blank()
	for y = 1, grid.ver do
		for x = 1, grid.hor do
			grid[y][x] = color.new(255,255,255)
		end
	end
end

function grid.blit(wtf)
	for y = 1, grid.ver do
		for x = 1, grid.hor do
			draw.fillrect(grid.x+(x-1)*grid.w, grid.y+(y-1)*grid.h, grid.w, grid.h,grid[y][x] or color.new(255,0,0))	
		end
	end
	if not wtf and pnt.testxy(1,1,grid.hor,grid.ver) then
		draw.rect(grid.x+(pnt.x-1)*grid.w, grid.y+(pnt.y-1)*grid.h, grid.w, grid.h,color.new(0,0,0))
	end	
end

function grid.checklimits()
	if grid.ver < 1 then grid.ver = 1 end
	if grid.hor < 1 then grid.hor = 1 end
	if grid.w < 1 then grid.w = 1 end
	if grid.h < 1 then grid.h = 1 end
	if grid.w*grid.hor > 640 then grid.hor = grid.hor -1 end
	if grid.h*grid.ver > 380 then grid.ver = grid.ver -1 end
end

function grid.fill()
	if controls.wiimote.two() then
		if controls.wiimote.press("up")    then grid.ver = grid.ver -1 grid.update() end
		if controls.wiimote.press("down")  then grid.ver = grid.ver +1 grid.update() end
		if controls.wiimote.press("left")  then grid.hor = grid.hor -1 grid.update() end
		if controls.wiimote.press("right") then grid.hor = grid.hor +1 grid.update() end
	elseif controls.wiimote.one() then
		if controls.wiimote.press("up")    then grid.h = grid.h -1 grid.update() end
		if controls.wiimote.press("down")  then grid.h = grid.h +1 grid.update() end
		if controls.wiimote.press("left")  then grid.w = grid.w -1 grid.update() end
		if controls.wiimote.press("right") then grid.w = grid.w +1 grid.update() end
	end
	--Si apuntas encima de la cuadricula
	if pnt.testxy(1,1,grid.hor,grid.ver) then
		if controls.wiimote.a() then
			grid[pnt.y][pnt.x] = clr[1]
		elseif controls.wiimote.b() then
			grid[pnt.y][pnt.x] = clr[2]
		elseif controls.nunchuk.c() then
			grid[pnt.y][pnt.x] = clr[3]		
		elseif controls.nunchuk.z() then
			grid[pnt.y][pnt.x] = clr[4]		
		end
	end
end

function show_colors(x,y,w,h,dist)
	for i = 1, #clr do
		draw.fillrect(x+(i-1)*dist,y,w,h,clr[i])
	end
end

function grid.save()
	local cnt = 1
	if not files.exists("capture") then files.mkdir("capture") end
	while files.exists("capture/image"..cnt..".png") do
		cnt = cnt+1
	end
	--[[full = image.create(grid.hor*grid.x,grid.ver*grid.h)
	mini = image.create(grid.w,grid.h)
	for y = 1, grid.ver do
		for x = 1, grid.hor do
			mini:clear(grid[y][x])
			full:blit((x-1)*grid.w,(y-1)*grid.h,mini)
		end
	end
	full:save("capture/image"..cnt..".png")
	full:free()
	mini:free()]]
	screen.flip()
	grid.blit(true)
	screen.flip()
	image.save("capture/image"..cnt..".png")
end


function puntero_blit()
	pnt.x = math.ceil((controls.wiimote.irx()-grid.x)/grid.w)
	pnt.y = math.ceil((controls.wiimote.iry()-grid.y)/grid.h)
	img.puntero:blit(controls.wiimote.irx(),controls.wiimote.iry())
end

function blit_info()
	screen.print(233,16,math.max(0,pnt.x).."/"..math.max(0,pnt.y))
	screen.print(366,16,grid.w.."/"..grid.h)
	screen.print(587,16,grid.hor.."/"..grid.ver)
end


splashsb2011()
grid.update()
while true do
img.bg:blit(0,0)
controls.read()

grid.fill()
grid.blit()
puntero_blit()
if controls.wiimote.press("minus") then grid.save() end
show_colors(30,440,25,25,30)
blit_info()
if controls.wiimote.home() then os.exit() end
if controls.nunchuk.analogy()>120 then image.save("image.png") end
if controls.wiimote.press("a") and controls.ircollision(588,429,45,45) then grid.blank() end
screen.flip()
if controls.wiimote.plus() then show_paleta() end
end